function CDX1 = merge_CDX_data(CDX1, CDX2)
% Impute the data from CDX2 into CDX1, unless already available

% Allocate memory
if (~isfield(CDX1, 'index_market_price'))
    CDX1.index_market_price = {zeros(size(CDX1.dates{1})) zeros(size(CDX1.dates{2})) zeros(size(CDX1.dates{3}))};
end
if ~isfield(CDX1, 'delta_tr_idx_GC')
    CDX1.delta_tr_idx_GC = {[] [] []};
    CDX1.delta_tr_idx_GC{1} = zeros(length(CDX1.dates{1}), 1);
    CDX1.delta_tr_idx_GC{2} = zeros(length(CDX1.dates{2}), 1);
    CDX1.delta_tr_idx_GC{3} = zeros(length(CDX1.dates{3}), 1);
end

% General cases
for j=1:length(CDX2.dates)
    % Determine new dates
    dates = CDX2.dates{j};
    new_pos = find(~ismember(dates, CDX1.dates{j}));
    new_dates = dates(new_pos);
    
    % Insert tranche price data (if date missing)
    for i=1:length(new_dates)
        % Determine position for insertion
        date = new_dates(i);
        pos = find(CDX1.dates{j} > date, 1, 'first');
        
        % Insert new date, price, ... into CDX1
        CDX1.dates{j} = [CDX1.dates{j}(1:(pos-1)); date; CDX1.dates{j}(pos:end)];
        CDX1.T{j} = [CDX1.T{j}(1:(pos-1)); CDX2.T{j}(new_pos(i)); CDX1.T{j}(pos:end)];
        CDX1.index_market_price{j} = [CDX1.index_market_price{j}(1:(pos-1)); CDX2.index_market_price{j}(new_pos(i)); CDX1.index_market_price{j}(pos:end)];
        CDX1.tranche_market_price_mid{j} = [CDX1.tranche_market_price_mid{j}(1:(pos-1),:); CDX2.tranche_market_price_mid{j}(new_pos(i),:); CDX1.tranche_market_price_mid{j}(pos:end,:)];
        CDX1.tranche_market_upfront_mid{j} = [CDX1.tranche_market_upfront_mid{j}(1:(pos-1),:); CDX2.tranche_market_upfront_mid{j}(new_pos(i),:); CDX1.tranche_market_upfront_mid{j}(pos:end,:)];
        if ((j==1) & isfield(CDX1, 'y0') & isfield(CDX2, 'y0'))
            CDX1.y0 = [CDX1.y0(1:(pos-1)); CDX2.y0(new_pos(i)); CDX1.y0(pos:end)];
        end
    end
    
    % Insert index price data (if price == 0) and GC deltas (if == 0)
    dates = CDX1.dates{j};
    dates2 = CDX2.dates{j};
    for i=1:length(dates)
        % Determine matching date
        date = dates(i);
        [ind, pos] = is_member_sorted_c(date, dates2);
        if (pos == 0)
            continue;
        end      
        % Insert Index prices
        if (CDX1.index_market_price{j}(i) == 0)
            CDX1.index_market_price{j}(i) = CDX2.index_market_price{j}(pos);
        end
        % Insert GC deltas
        if (CDX1.delta_tr_idx_GC{j}(i) == 0)
            CDX1.delta_tr_idx_GC{j}(i) = CDX2.delta_tr_idx_GC{j}(pos);
        end
    end
end

% Special case1: 5Y senior tranche price on 06-Sep-2005 missing in Markit data
pos_old = find(CDX1.dates{1} == datenum('09/06/2005'));
pos_new = find(CDX2.dates{1} == datenum('09/06/2005'));
CDX1.tranche_market_price_mid{1}(pos_old,5) = CDX2.tranche_market_price_mid{1}(pos_new,5);
CDX1.T{1}(pos_old) = CDX2.T{1}(pos_new);

% Special case2: 5Y prices on 01-Sept-2006 seem to be off
pos_old = find(CDX1.dates{1} == datenum('09/01/2006'));
pos_new = find(CDX2.dates{1} == datenum('09/01/2006'));
if (~isempty(pos_old) & ~isempty(pos_new))
    CDX1.tranche_market_upfront_mid{1}(pos_old,:) = CDX2.tranche_market_upfront_mid{1}(pos_new,:);
    CDX1.tranche_market_price_mid{1}(pos_old,:) = CDX2.tranche_market_price_mid{1}(pos_new,:);
    CDX1.T{1}(pos_old) = max(CDX1.T{1}(pos_old), CDX2.T{1}(pos_new));
else % use last available data
    CDX1.tranche_market_upfront_mid{1}(pos_old,:) = CDX1.tranche_market_upfront_mid{1}(pos_old-1,:);
    CDX1.tranche_market_price_mid{1}(pos_old,:) = CDX1.tranche_market_price_mid{1}(pos_old-1,:);
    CDX1.T{1}(pos_old) = CDX1.T{1}(pos_old-1) - 1/360;
end

% Special case3: spread for 3-7%, 10Y tranche on 11-Oct-2005 is 2590 basis points, which is much too
% high (Excel cell: N2924)
pos_old = find(CDX1.dates{1} == datenum('10/11/2005'));
pos_new = find(CDX2.dates{1} == datenum('10/11/2005'));
CDX1.tranche_market_price_mid{1}(pos_old,2) = CDX2.tranche_market_price_mid{1}(pos_new,2);

% Special case4: 5Y prices on 27-Sept-2006 missing
pos_old = find(CDX1.dates{1} == datenum('09/27/2006'));
pos_new = find(CDX2.dates{1} == datenum('09/27/2006'));
if (~isempty(pos_old) & ~isempty(pos_new))
    CDX1.tranche_market_upfront_mid{1}(pos_old,:) = CDX2.tranche_market_upfront_mid{1}(pos_new,:);
    CDX1.tranche_market_price_mid{1}(pos_old,:) = CDX2.tranche_market_price_mid{1}(pos_new,:);
    CDX1.T{1}(pos_old) = max(CDX1.T{1}(pos_old), CDX2.T{1}(pos_new));
else % use last available data
    CDX1.tranche_market_upfront_mid{1}(pos_old,:) = CDX1.tranche_market_upfront_mid{1}(pos_old-1,:);
    CDX1.tranche_market_price_mid{1}(pos_old,:) = CDX1.tranche_market_price_mid{1}(pos_old-1,:);
    CDX1.T{1}(pos_old) = CDX1.T{1}(pos_old-1) - date_diff_years(CDX1.dates{1}(pos_old-1), CDX1.dates{1}(pos_old));
end

